/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shadow.aikar.commands;

import com.velocitypowered.api.command.Command;
import com.velocitypowered.api.command.CommandMeta;
import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.plugin.Plugin;
import com.velocitypowered.api.plugin.PluginContainer;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ProxyServer;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.kyori.adventure.text.format.NamedTextColor;
import net.skinsrestorer.shadow.aikar.commands.ACFPatterns;
import net.skinsrestorer.shadow.aikar.commands.ACFVelocityListener;
import net.skinsrestorer.shadow.aikar.commands.BaseCommand;
import net.skinsrestorer.shadow.aikar.commands.CommandCompletionContext;
import net.skinsrestorer.shadow.aikar.commands.CommandCompletions;
import net.skinsrestorer.shadow.aikar.commands.CommandContexts;
import net.skinsrestorer.shadow.aikar.commands.CommandIssuer;
import net.skinsrestorer.shadow.aikar.commands.CommandManager;
import net.skinsrestorer.shadow.aikar.commands.CommandParameter;
import net.skinsrestorer.shadow.aikar.commands.LogLevel;
import net.skinsrestorer.shadow.aikar.commands.MessageType;
import net.skinsrestorer.shadow.aikar.commands.RegisteredCommand;
import net.skinsrestorer.shadow.aikar.commands.RootCommand;
import net.skinsrestorer.shadow.aikar.commands.VelocityCommandCompletionContext;
import net.skinsrestorer.shadow.aikar.commands.VelocityCommandCompletions;
import net.skinsrestorer.shadow.aikar.commands.VelocityCommandContexts;
import net.skinsrestorer.shadow.aikar.commands.VelocityCommandExecutionContext;
import net.skinsrestorer.shadow.aikar.commands.VelocityCommandIssuer;
import net.skinsrestorer.shadow.aikar.commands.VelocityConditionContext;
import net.skinsrestorer.shadow.aikar.commands.VelocityLocales;
import net.skinsrestorer.shadow.aikar.commands.VelocityMessageFormatter;
import net.skinsrestorer.shadow.aikar.commands.VelocityRootCommand;
import net.skinsrestorer.shadow.aikar.commands.apachecommonslang.ApacheCommonsExceptionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VelocityCommandManager
extends CommandManager<CommandSource, VelocityCommandIssuer, NamedTextColor, VelocityMessageFormatter, VelocityCommandExecutionContext, VelocityConditionContext> {
    protected final ProxyServer proxy;
    protected final PluginContainer plugin;
    protected Map<String, VelocityRootCommand> registeredCommands = new HashMap<String, VelocityRootCommand>();
    protected VelocityCommandContexts contexts;
    protected VelocityCommandCompletions completions;
    protected VelocityLocales locales;

    public VelocityCommandManager(ProxyServer proxy, Object plugin) {
        this.proxy = proxy;
        this.plugin = (PluginContainer)proxy.getPluginManager().getPlugin(plugin.getClass().getAnnotation(Plugin.class).id()).get();
        this.defaultFormatter = new VelocityMessageFormatter(NamedTextColor.RED, NamedTextColor.YELLOW, NamedTextColor.RED);
        this.formatters.put(MessageType.ERROR, this.defaultFormatter);
        this.formatters.put(MessageType.SYNTAX, new VelocityMessageFormatter(NamedTextColor.YELLOW, NamedTextColor.GREEN, NamedTextColor.WHITE));
        this.formatters.put(MessageType.INFO, new VelocityMessageFormatter(NamedTextColor.BLUE, NamedTextColor.DARK_GREEN, NamedTextColor.GREEN));
        this.formatters.put(MessageType.HELP, new VelocityMessageFormatter(NamedTextColor.AQUA, NamedTextColor.GREEN, NamedTextColor.YELLOW));
        this.getLocales();
        proxy.getEventManager().register(plugin, (Object)new ACFVelocityListener(this, this.plugin, proxy));
        this.registerDependency(plugin.getClass(), plugin);
        this.registerDependency(Plugin.class, plugin);
        this.registerDependency(ProxyServer.class, proxy);
    }

    public ProxyServer getProxy() {
        return this.proxy;
    }

    public PluginContainer getPlugin() {
        return this.plugin;
    }

    @Override
    public synchronized CommandContexts<VelocityCommandExecutionContext> getCommandContexts() {
        if (this.contexts == null) {
            this.contexts = new VelocityCommandContexts(this.proxy, this);
        }
        return this.contexts;
    }

    @Override
    public synchronized CommandCompletions<VelocityCommandCompletionContext> getCommandCompletions() {
        if (this.completions == null) {
            this.completions = new VelocityCommandCompletions(this.proxy, this);
        }
        return this.completions;
    }

    @Override
    public VelocityLocales getLocales() {
        if (this.locales == null) {
            this.locales = new VelocityLocales(this);
            this.locales.loadLanguages();
        }
        return this.locales;
    }

    public void readLocale(Player player) {
        if (!player.isActive()) {
            return;
        }
        Locale locale = player.getPlayerSettings().getLocale();
        if (locale != null) {
            this.setIssuerLocale(player, player.getPlayerSettings().getLocale());
        }
    }

    @Override
    public void registerCommand(BaseCommand command) {
        this.registerCommand(command, false);
    }

    public void registerCommand(BaseCommand command, boolean force) {
        command.onRegister(this);
        for (Map.Entry<String, RootCommand> entry : command.registeredCommands.entrySet()) {
            String commandName = entry.getKey().toLowerCase(Locale.ENGLISH);
            VelocityRootCommand velocityCommand = (VelocityRootCommand)entry.getValue();
            if (!velocityCommand.isRegistered) {
                if (force) {
                    this.proxy.getCommandManager().unregister(commandName);
                }
                CommandMeta meta = this.proxy.getCommandManager().metaBuilder(commandName).build();
                this.proxy.getCommandManager().register(meta, (Command)velocityCommand);
            }
            velocityCommand.isRegistered = true;
            this.registeredCommands.put(commandName, velocityCommand);
        }
    }

    public void unregisterCommand(BaseCommand command) {
        for (Map.Entry<String, RootCommand> entry : command.registeredCommands.entrySet()) {
            String commandName = entry.getKey().toLowerCase(Locale.ENGLISH);
            VelocityRootCommand velocityCommand = (VelocityRootCommand)entry.getValue();
            velocityCommand.getSubCommands().values().removeAll(command.subCommands.values());
            if (!velocityCommand.getSubCommands().isEmpty() || !velocityCommand.isRegistered) continue;
            this.unregisterCommand(velocityCommand);
            velocityCommand.isRegistered = false;
            this.registeredCommands.remove(commandName);
        }
    }

    public void unregisterCommand(VelocityRootCommand command) {
        this.proxy.getCommandManager().unregister(command.getCommandName());
    }

    public void unregisterCommands() {
        for (Map.Entry<String, VelocityRootCommand> entry : this.registeredCommands.entrySet()) {
            this.unregisterCommand(entry.getValue());
        }
    }

    @Override
    public boolean hasRegisteredCommands() {
        return !this.registeredCommands.isEmpty();
    }

    @Override
    public boolean isCommandIssuer(Class<?> aClass) {
        return CommandSource.class.isAssignableFrom(aClass);
    }

    @Override
    public VelocityCommandIssuer getCommandIssuer(Object issuer) {
        if (!(issuer instanceof CommandSource)) {
            throw new IllegalArgumentException(issuer.getClass().getName() + " is not a Command Issuer.");
        }
        return new VelocityCommandIssuer(this, (CommandSource)issuer);
    }

    @Override
    public RootCommand createRootCommand(String cmd) {
        return new VelocityRootCommand(this, cmd);
    }

    @Override
    public Collection<RootCommand> getRegisteredRootCommands() {
        return Collections.unmodifiableCollection(this.registeredCommands.values());
    }

    @Override
    public VelocityCommandExecutionContext createCommandContext(RegisteredCommand command, CommandParameter parameter, CommandIssuer sender, List<String> args, int i, Map<String, Object> passedArgs) {
        return new VelocityCommandExecutionContext(command, parameter, (VelocityCommandIssuer)sender, args, i, passedArgs);
    }

    @Override
    public CommandCompletionContext createCompletionContext(RegisteredCommand command, CommandIssuer sender, String input, String config, String[] args) {
        return new VelocityCommandCompletionContext(command, (VelocityCommandIssuer)sender, input, config, args);
    }

    @Override
    public RegisteredCommand createRegisteredCommand(BaseCommand command, String cmdName, Method method, String prefSubCommand) {
        return new RegisteredCommand(command, cmdName, method, prefSubCommand);
    }

    @Override
    public VelocityConditionContext createConditionContext(CommandIssuer issuer, String config) {
        return new VelocityConditionContext((VelocityCommandIssuer)issuer, config);
    }

    @Override
    public void log(LogLevel level, String message, Throwable throwable) {
        Logger logger = LoggerFactory.getLogger(this.plugin.getClass());
        if (level == LogLevel.INFO) {
            logger.info("[ACF] " + message);
        } else {
            logger.warn("[ACF] " + message);
        }
        if (throwable != null) {
            for (String line : ACFPatterns.NEWLINE.split(ApacheCommonsExceptionUtil.getFullStackTrace(throwable))) {
                if (level == LogLevel.INFO) {
                    logger.info("[ACF] " + line);
                    continue;
                }
                logger.warn("[ACF] " + line);
            }
        }
    }

    @Override
    public String getCommandPrefix(CommandIssuer issuer) {
        return issuer.isPlayer() ? "/" : "";
    }
}

